package org.beast.logger.web.servlet;

import brave.Tracing;
import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import jakarta.servlet.*;
import org.slf4j.MDC;


import java.io.IOException;

public class Slf4jTracingFilter implements Filter {

    private static final String TRACE_ID_KEY = "X-TraceID";
    private Tracing tracing;

    public static Slf4jTracingFilter create(Tracing tracing) {
        return new Slf4jTracingFilter(tracing);
    }

    protected Slf4jTracingFilter(Tracing tracing) {
        this.tracing = tracing;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        TraceContext context = tracing.currentTraceContext().get();
        String traceId = context.traceIdString();
        MDC.put(TRACE_ID_KEY, traceId);
        chain.doFilter(request, response);
        MDC.remove(TRACE_ID_KEY);
    }

}
