/*
 * Decompiled with CFR 0.152.
 */
package org.beast.logger.web.servlet;

import brave.http.HttpTracing;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import org.beast.logger.web.servlet.Slf4jTracingFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={HttpTracing.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class Slf4jTraceWebServletAutoConfiguration {
    @Bean
    public Slf4jTracingFilter slf4jTracingFilter(HttpTracing tracing) {
        return Slf4jTracingFilter.create(tracing);
    }

    @Bean
    public FilterRegistrationBean<Slf4jTracingFilter> slf4jTraceWebFilter(Slf4jTracingFilter tracingFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)tracingFilter, new ServletRegistrationBean[0]);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
        filterRegistrationBean.setOrder(-2147483642);
        return filterRegistrationBean;
    }
}

