/*
 * Decompiled with CFR 0.152.
 */
package org.beast.logger.web.server;

import io.micrometer.observation.Observation;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.handler.DefaultTracingObservationHandler;
import io.micrometer.tracing.handler.TracingObservationHandler;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.lang.NonNull;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.util.context.Context;

public class Slf4jTraceWebFilter
implements WebFilter {
    private static final Logger log = LoggerFactory.getLogger(Slf4jTraceWebFilter.class);
    private static final String TRACE_ID_KEY = "X-TraceID";
    private BeanFactory beanFactory;
    private DefaultTracingObservationHandler observationHandler;

    public Slf4jTraceWebFilter(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    private DefaultTracingObservationHandler getObservationHandler() {
        if (this.observationHandler == null) {
            this.observationHandler = (DefaultTracingObservationHandler)this.beanFactory.getBean(DefaultTracingObservationHandler.class);
        }
        return this.observationHandler;
    }

    @Nonnull
    public Mono<Void> filter(@Nonnull ServerWebExchange exchange, @Nonnull WebFilterChain chain) {
        final String contextKey = "micrometer.observation";
        return new MonoOperator<Void, Void>(chain.filter(exchange)){

            public void subscribe(@NonNull CoreSubscriber<? super Void> subscriber) {
                Context context = subscriber.currentContext();
                if (context.hasKey((Object)contextKey)) {
                    String key = Slf4jTraceWebFilter.TRACE_ID_KEY;
                    Observation observation = (Observation)context.get((Object)contextKey);
                    TracingObservationHandler.TracingContext trackingContext = Slf4jTraceWebFilter.this.getObservationHandler().getTracingContext(observation.getContext());
                    TraceContext traceContext = trackingContext.getSpan().context();
                    String traceId = traceContext.traceId();
                    MDC.put((String)Slf4jTraceWebFilter.TRACE_ID_KEY, (String)traceId);
                    this.source.subscribe(subscriber);
                    MDC.remove((String)Slf4jTraceWebFilter.TRACE_ID_KEY);
                } else {
                    log.warn("context not exist key: TraceContext");
                    this.source.subscribe(subscriber);
                }
            }
        };
    }
}

