package org.beast.logger.web.server;

import brave.Tracing;
import io.micrometer.tracing.handler.TracingObservationHandler;
import org.beast.logger.web.WebFiltersOrder;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
//import org.springframework.cloud.sleuth.autoconfig.instrument.web.TraceWebAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;


@Configuration
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnBean(TracingObservationHandler.class)
public class Slfj4TrackWebServerAutoConfiguration {

    @Bean
    @Order(WebFiltersOrder.TRACE_WEB)
    public Slf4jTraceWebFilter slf4jTraceWebFilter(BeanFactory beanFactory) {
        return new Slf4jTraceWebFilter(beanFactory);
    }

}
