/*
 * Decompiled with CFR 0.152.
 */
package org.beast.logger.web.servlet;

import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.slf4j.MDC;

public class Slf4jTracingFilter
implements Filter {
    private static final String TRACE_ID_KEY = "X-TraceID";
    private HttpTracing tracing;

    public static Slf4jTracingFilter create(HttpTracing httpTracing) {
        return new Slf4jTracingFilter(httpTracing);
    }

    protected Slf4jTracingFilter(HttpTracing tracing) {
        this.tracing = tracing;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        TraceContext context = this.tracing.tracing().currentTraceContext().get();
        String traceId = context.traceIdString();
        MDC.put((String)TRACE_ID_KEY, (String)traceId);
        chain.doFilter(request, response);
        MDC.remove((String)TRACE_ID_KEY);
    }
}

