package org.beast.logger.web.servlet;


import brave.http.HttpTracing;
import jakarta.servlet.DispatcherType;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;


import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;


@Configuration(proxyBeanMethods = false)
@ConditionalOnBean(HttpTracing.class)
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
//@AutoConfigureAfter(BraveAutoConfiguration.class)
public class Slf4jTraceWebServletAutoConfiguration {

    @Bean
    public Slf4jTracingFilter slf4jTracingFilter(HttpTracing tracing) {
        return Slf4jTracingFilter.create(tracing);

    }

    @Bean
    public FilterRegistrationBean<Slf4jTracingFilter> slf4jTraceWebFilter(
            Slf4jTracingFilter tracingFilter
    ) {
        FilterRegistrationBean<Slf4jTracingFilter> filterRegistrationBean = new FilterRegistrationBean<>(
            tracingFilter
        );
        filterRegistrationBean.setDispatcherTypes(
                DispatcherType.ASYNC,
                DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE,
                DispatcherType.REQUEST
        );
        filterRegistrationBean.setOrder(
                Ordered.HIGHEST_PRECEDENCE + 6
        );

        return filterRegistrationBean;
    }



}
