package org.beast.logger.web.server;

import brave.Tracer;
import brave.http.HttpTracing;
import io.micrometer.tracing.TraceContext;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.lang.NonNull;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.util.WebUtils;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.util.context.Context;

import javax.annotation.Nonnull;

@Slf4j
public class Slf4jTraceWebFilter implements WebFilter {

    private static final String TRACE_ID_KEY = "X-TraceID";
//    public static final int ORDER = Ordered.HIGHEST_PRECEDENCE + 900;
////    private String span;
//    private HttpTracing tracing;
//
//    public HttpResponseInjectingTraceFilter(HttpTracing tracing) {
//        this.tracing = tracing;
////        this.span = "tracker";
//    }

    private BeanFactory beanFactory;
    private HttpTracing tracing;
    private Tracer tracer;

    public Slf4jTraceWebFilter(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }



    @Override
    public @Nonnull
    Mono<Void> filter(@Nonnull ServerWebExchange exchange, @Nonnull WebFilterChain chain) {

        return new MonoOperator<>(chain.filter(exchange)) {
            @Override
            public void subscribe(@NonNull CoreSubscriber<? super Void> subscriber) {
                Context context = subscriber.currentContext();
                if (context.hasKey(TraceContext.class)) {
                    final String key = TRACE_ID_KEY;
                    TraceContext traceContext = context.get(TraceContext.class);
                    String traceId = traceContext.traceId();
                    MDC.put(key, traceId);
                    this.source.subscribe(subscriber);
                    log.debug("Context Set Header TraceId:[{}] Sampled: sampled:[{}]", traceId, traceContext.sampled());
                    MDC.remove(key);
                } else {
                    log.warn("context not exist key: TraceContext");
                    this.source.subscribe(subscriber);
                }
            }
        };


//        String attr = TraceWebFilter.class.getName() + ".TRACE";
//        Span span = (Span) exchange.getAttributes().get(attr);
//        if (span != null) {
//            TraceContext context = span.context();
//            ServerHttpResponse response = exchange.getResponse();
//            final String key = "X-TraceID";
//            String traceId = context.traceIdString();
//            MDC.put(key, traceId);
//            response.getHeaders().set(key, traceId);
//            log.debug("Context Set Header TraceId:[{}] Sampled: sampled:[{}] sampledLocal:[{}]", traceId, context.sampled(), context.sampledLocal());
//
//            return chain.filter(exchange).doOnTerminate(() -> {
//                MDC.remove(key);
//            });
//        } else {
//            return chain.filter(exchange);
//        }


//        TraceContext context = this.getTracing().tracing()
//                .currentTraceContext()
//                .get();
//        if (context == null) {
//            return chain.filter(exchange);
//        }
//        ServerHttpResponse response = exchange.getResponse();
//
//        final String key = "X-TraceID";
//
//        String traceId = context.traceIdString();
//        MDC.put(key, traceId);
//        response.getHeaders().set(key, traceId);
//        log.debug("Context Set Header TraceId:[{}] Sampled: sampled:[{}] sampledLocal:[{}]", traceId, context.sampled(), context.sampledLocal());
//
//        return chain.filter(exchange).doOnTerminate(() -> {
//            MDC.remove(key);
//        });
    }

//    SleuthWebProperties webProperties;
//
//    SleuthWebProperties sleuthWebProperties() {
//        if (this.webProperties == null) {
//            this.webProperties = this.beanFactory.getBean(SleuthWebProperties.class);
//        }
//        return this.webProperties;
//    }


//    @Override
//    public int getOrder() {
//        return HandWebFiltersOrder.TRACE_WEB_INJECT;
////        return 0;
////        return sleuthWebProperties().getFilterOrder() + 1;
//    }


//    @Override
//    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
//
//
//        TraceContext currentSpan = tracing.tracing().currentTraceContext().get();
//        ServerHttpResponse response = exchange.getResponse();
//        if (currentSpan != null) {
//            response.getHeaders().set("X-TrackID", currentSpan.traceIdString());
//        }
//        return chain.filter(exchange);
////        Tracer tracer = tracing.tracer();
////        TraceContext parent = tracing.currentTraceContext().get();
////        ScopedSpan span = tracer.startScopedSpanWithParent(this.span, parent);
////        try {
//
////        } catch (Exception | Error e) {
////            span.error(e);
////            throw e;
////        } finally {
////            span.finish();
////        }
//    }
//
//    @Override
//    public int getOrder() {
//        return Ordered.HIGHEST_PRECEDENCE + 900;
//    }
}
