/*
 * Decompiled with CFR 0.152.
 */
package org.beast.logger.web.servlet;

import brave.http.HttpTracing;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.beast.logger.web.servlet.Slf4jTracingFilter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={HttpTracing.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
public class Slf4jTraceWebServletAutoConfiguration {
    @Bean
    public FilterRegistrationBean<Slf4jTracingFilter> slf4jTraceWebFilter(Slf4jTracingFilter tracingFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)tracingFilter, new ServletRegistrationBean[0]);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
        filterRegistrationBean.setOrder(-2147483642);
        return filterRegistrationBean;
    }

    @Bean
    public Slf4jTracingFilter slf4jTracingFilter(HttpTracing tracing) {
        return Slf4jTracingFilter.create(tracing);
    }
}

