/*
 * Decompiled with CFR 0.152.
 */
package org.beast.graphql.data;

import java.util.List;
import java.util.stream.Collectors;
import org.beast.data.relay.Connection;
import org.beast.data.relay.Edge;
import org.beast.data.relay.PageInfo;
import org.springframework.lang.Nullable;

public class GraphQLConnection<T> {
    private List<Edge<T>> edges;
    private List<T> nodes;
    private PageInfo pageInfo;
    @Nullable
    private Long totalCount;

    public GraphQLConnection(List<Edge<T>> edges, PageInfo pageInfo, @Nullable Long totalCount) {
        this.edges = edges;
        this.pageInfo = pageInfo;
        this.totalCount = totalCount;
        this.nodes = edges.stream().map(Edge::getNode).collect(Collectors.toList());
    }

    public GraphQLConnection(List<Edge<T>> edges, PageInfo pageInfo) {
        this(edges, pageInfo, null);
    }

    public static <T> GraphQLConnection<T> valueOf(Connection<T> connection) {
        List edges = connection.getEdges();
        Long totalCount = connection.getTotalCount();
        PageInfo pageInfo = connection.getPageInfo();
        return new GraphQLConnection<T>(edges, pageInfo, totalCount);
    }

    public List<Edge<T>> getEdges() {
        return this.edges;
    }

    public List<T> getNodes() {
        return this.nodes;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    @Nullable
    public Long getTotalCount() {
        return this.totalCount;
    }
}

