package org.beast.graphql.data;



import org.beast.data.relay.Connection;
import org.beast.data.relay.Edge;
import org.beast.data.relay.PageInfo;
import org.springframework.lang.Nullable;

import java.util.List;
import java.util.stream.Collectors;

public class GraphQLConnection<T>  {

    private List<Edge<T>> edges;

    private List<T> nodes;

    private PageInfo pageInfo;

    private @Nullable Long totalCount;

    public GraphQLConnection(List<Edge<T>> edges, PageInfo pageInfo, @Nullable Long totalCount) {
        this.edges = edges;
        this.pageInfo = pageInfo;
        this.totalCount = totalCount;
        this.nodes = edges.stream().map(Edge::getNode).collect(Collectors.toList());
    }

    public GraphQLConnection(List<Edge<T>> edges, PageInfo pageInfo) {
        this(edges, pageInfo, null);
    }


    public static <T> GraphQLConnection<T> valueOf(Connection<T> connection) {

        var edges = connection.getEdges();
        var totalCount = connection.getTotalCount();
        var pageInfo = connection.getPageInfo();

        return new GraphQLConnection<>(edges, pageInfo, totalCount);
    }

    public List<Edge<T>> getEdges() {
        return edges;
    }

    public List<T> getNodes() {
        return nodes;
    }

    public PageInfo getPageInfo() {
        return pageInfo;
    }

    @Nullable
    public Long getTotalCount() {
        return totalCount;
    }
}
