package org.beast.graphql.resolver;


import graphql.schema.DataFetchingEnvironment;
import org.beast.data.relay.SimpleCursor;
import org.beast.data.relay.Pageable;
import org.beast.data.relay.PageableRequest;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

import java.util.Optional;

public class PageableMethodArgumentResolver implements HandlerMethodArgumentResolver {

//    private final MessageConverterArgumentConverter argumentConverter;

    public PageableMethodArgumentResolver() {
//        this.argumentConverter = new MessageConverterArgumentConverter(converter);
    }

    @Override
    public boolean supportsParameter(@NonNull MethodParameter parameter) {
        return Pageable.class.equals(parameter.getParameterType());
    }

    @Nullable
    @Override
    public Object resolveArgument(@NonNull MethodParameter parameter, @NonNull DataFetchingEnvironment environment) throws Exception {
        var after = SimpleCursor.ofNullable(environment.getArgument("after"));
        var before = SimpleCursor.ofNullable(environment.getArgument("before"));
        Integer first = environment.getArgument("first");
        Integer last = environment.getArgument("last");
        Integer offset = environment.getArgument("offset");

        Boolean reverseBoolean = environment.getArgument("reverse");
        boolean reverse = Optional.ofNullable(reverseBoolean).orElse(false);
        Sort.Direction direction = reverse ? Sort.Direction.ASC : Sort.Direction.DESC;
        Sort sort = Sort.unsorted();
        String sortBy = environment.getArgument("sortBy");

        if (sortBy != null) {
            //默认降序
            sort = Sort.by(direction, sortBy);
        }

        return PageableRequest.of(after, before, first, last, offset, sort);
    }

}
