/*
 * Decompiled with CFR 0.152.
 */
package org.beast.graphql.resolver;

import graphql.schema.DataFetchingEnvironment;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class SortMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(@NonNull MethodParameter parameter) {
        return Sort.class.equals((Object)parameter.getParameterType());
    }

    @Nullable
    public Object resolveArgument(@NonNull MethodParameter parameter, @NonNull DataFetchingEnvironment environment) throws Exception {
        Boolean reverseBoolean = (Boolean)environment.getArgument("reverse");
        boolean reverse = Optional.ofNullable(reverseBoolean).orElse(false);
        Sort.Direction direction = reverse ? Sort.Direction.ASC : Sort.Direction.DESC;
        Sort sort = Sort.unsorted();
        String sortBy = (String)environment.getArgument("sortBy");
        if (sortBy != null) {
            sort = Sort.by((Sort.Direction)direction, (String[])new String[]{sortBy});
        }
        return sort;
    }
}

