/*
 * Decompiled with CFR 0.152.
 */
package org.beast.graphql.resolver;

import graphql.schema.DataFetchingEnvironment;
import java.util.Optional;
import org.beast.data.relay.Cursor;
import org.beast.data.relay.DefaultCursor;
import org.beast.data.relay.Pageable;
import org.beast.data.relay.PageableRequest;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class PageableMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(@NonNull MethodParameter parameter) {
        return Pageable.class.equals((Object)parameter.getParameterType());
    }

    @Nullable
    public Object resolveArgument(@NonNull MethodParameter parameter, @NonNull DataFetchingEnvironment environment) throws Exception {
        DefaultCursor after = DefaultCursor.ofNullable((String)((String)environment.getArgument("after")));
        DefaultCursor before = DefaultCursor.ofNullable((String)((String)environment.getArgument("before")));
        Integer first = (Integer)environment.getArgument("first");
        Integer last = (Integer)environment.getArgument("last");
        Integer offset = (Integer)environment.getArgument("offset");
        Boolean reverseBoolean = (Boolean)environment.getArgument("reverse");
        boolean reverse = Optional.ofNullable(reverseBoolean).orElse(false);
        Sort.Direction direction = reverse ? Sort.Direction.ASC : Sort.Direction.DESC;
        Sort sort = Sort.unsorted();
        String sortBy = (String)environment.getArgument("sortBy");
        if (sortBy != null) {
            sort = Sort.by((Sort.Direction)direction, (String[])new String[]{sortBy});
        }
        return PageableRequest.of((Cursor)after, (Cursor)before, (Integer)first, (Integer)last, (Integer)offset, (Sort)sort);
    }
}

