/*
 * Decompiled with CFR 0.152.
 */
package org.beast.graphql.querydsl;

import java.io.Serializable;
import org.beast.data.querydsl.CursorEncoder;
import org.beast.data.querydsl.CursorPredicateFactory;
import org.beast.graphql.querydsl.GraphqlQuerydslMongoPredicateExecutor;
import org.beast.graphql.querydsl.GraphqlQuerydslPredicateExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.MappingMongoEntityInformation;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactory;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactoryBean;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class CustomMongoRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends MongoRepositoryFactoryBean<T, S, ID> {
    private CursorPredicateFactory cursorPredicateFactory;
    private CursorEncoder cursorEncoder;

    public CustomMongoRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    @Autowired
    public void setCursorSortService(CursorPredicateFactory cursorPredicateFactory) {
        this.cursorPredicateFactory = cursorPredicateFactory;
    }

    @Autowired
    public void setCursorEncoder(CursorEncoder cursorEncoder) {
        this.cursorEncoder = cursorEncoder;
    }

    @NonNull
    protected RepositoryFactorySupport createRepositoryFactory() {
        return super.createRepositoryFactory();
    }

    @NonNull
    protected RepositoryFactorySupport getFactoryInstance(final @NonNull MongoOperations operations) {
        final MappingContext mappingContext = operations.getConverter().getMappingContext();
        return new MongoRepositoryFactory(operations){

            public <T, ID> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass, @Nullable RepositoryMetadata metadata) {
                MongoPersistentEntity entity = (MongoPersistentEntity)mappingContext.getRequiredPersistentEntity(domainClass);
                Class idType = metadata != null ? metadata.getIdType() : null;
                return new MappingMongoEntityInformation(entity, idType);
            }

            @NonNull
            protected RepositoryComposition.RepositoryFragments getRepositoryFragments(@NonNull RepositoryMetadata metadata) {
                boolean isGraphqlMongoQueryDslRepository;
                RepositoryComposition.RepositoryFragments fragments = super.getRepositoryFragments(metadata);
                boolean bl = isGraphqlMongoQueryDslRepository = QuerydslUtils.QUERY_DSL_PRESENT && GraphqlQuerydslPredicateExecutor.class.isAssignableFrom(metadata.getRepositoryInterface());
                if (isGraphqlMongoQueryDslRepository) {
                    if (metadata.isReactiveRepository()) {
                        throw new InvalidDataAccessApiUsageException("Cannot combine Querydsl and reactive repository support in a single interface");
                    }
                    MongoEntityInformation entityInformation = this.getEntityInformation(metadata.getDomainType(), metadata);
                    fragments = fragments.append(RepositoryFragment.implemented((Object)this.instantiateClass(GraphqlQuerydslMongoPredicateExecutor.class, new Object[]{entityInformation, operations, CustomMongoRepositoryFactoryBean.this.cursorPredicateFactory, CustomMongoRepositoryFactoryBean.this.cursorEncoder})));
                }
                return fragments;
            }
        };
    }
}

