/*
 * Decompiled with CFR 0.152.
 */
package org.beast.graphql.data;

import java.util.Optional;
import org.beast.graphql.data.ConnectionCursor;
import org.springframework.data.domain.Sort;

public class Pageable {
    private final ConnectionCursor after;
    private final ConnectionCursor before;
    private final Integer first;
    private final Integer last;
    private final Integer offset;
    private final Sort sort;

    private Pageable(ConnectionCursor after, ConnectionCursor before, Integer first, Integer last, Integer offset, Sort sort) {
        this.sort = sort;
        if (first != null && last != null) {
            throw new IllegalArgumentException("Passing both `first` and `last` to paginate connection is not supported.");
        }
        if (first != null && first < 0) {
            throw new IllegalArgumentException();
        }
        if (last != null && last < 0) {
            throw new IllegalArgumentException();
        }
        if (offset != null && last != null) {
            throw new IllegalArgumentException("Passing both `offset` and `last` to paginate connection is not supported.");
        }
        this.after = after;
        this.before = before;
        this.first = first;
        this.last = last;
        this.offset = offset;
    }

    public static Pageable first(Integer first) {
        return Pageable.of(null, null, first, null, null);
    }

    public static Pageable last(Integer last) {
        return Pageable.of(null, null, null, last, null);
    }

    public static Pageable cursorBasedFirst(ConnectionCursor after, ConnectionCursor before, Integer first) {
        return Pageable.of(after, before, first, null, null);
    }

    public static Pageable cursorBasedLast(ConnectionCursor after, ConnectionCursor before, Integer last) {
        return Pageable.of(after, before, null, last, null);
    }

    public static Pageable offsetBasedFirst(Integer offset, Integer last) {
        return Pageable.of(null, null, null, last, offset);
    }

    public static Pageable ofCursorBased(ConnectionCursor after, ConnectionCursor before, Integer first, Integer last) {
        return Pageable.of(after, before, first, last, null);
    }

    public static Pageable ofOffsetBased(Integer offset, Integer first) {
        return Pageable.of(null, null, first, null, offset);
    }

    public static Pageable of(ConnectionCursor after, ConnectionCursor before, Integer first, Integer last, Integer offset) {
        return new Pageable(after, before, first, last, offset, Sort.unsorted());
    }

    public static Pageable of(ConnectionCursor after, ConnectionCursor before, Integer first, Integer last, Integer offset, Sort sort) {
        return new Pageable(after, before, first, last, offset, sort);
    }

    public static Pageable of(Pageable pageable, Sort sort) {
        return Pageable.of(pageable.after, pageable.before, pageable.first, pageable.last, pageable.offset, sort);
    }

    public static Pageable empty() {
        return Pageable.of(null, null, null, null, null, null);
    }

    public Pageable with(Sort sort) {
        return Pageable.of(this, sort);
    }

    public Integer getFirst() {
        return this.first;
    }

    public Optional<Integer> getFirstOptional() {
        return Optional.ofNullable(this.first);
    }

    public Integer getLast() {
        return this.last;
    }

    public Optional<Integer> getLastOptional() {
        return Optional.ofNullable(this.last);
    }

    public ConnectionCursor getAfter() {
        return this.after;
    }

    public Optional<ConnectionCursor> getAfterOptional() {
        return Optional.ofNullable(this.after);
    }

    public ConnectionCursor getBefore() {
        return this.before;
    }

    public Optional<ConnectionCursor> getBeforeOptional() {
        return Optional.ofNullable(this.before);
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Optional<Integer> getOffsetOptional() {
        return Optional.ofNullable(this.offset);
    }

    public Sort getSort() {
        return this.sort;
    }
}

