/*
 * Decompiled with CFR 0.152.
 */
package org.beast.graphql.configuration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.beast.graphql.data.ConnectionCursor;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class GraphqlJacksonAutoConfiguration {
    @Bean
    public Jackson2ObjectMapperBuilderCustomizer graphqlJackson2ObjectMapperBuilderCustomizer() {
        return jacksonObjectMapperBuilder -> {
            jacksonObjectMapperBuilder.serializationInclusion(JsonInclude.Include.ALWAYS);
            jacksonObjectMapperBuilder.serializerByType(ConnectionCursor.class, (JsonSerializer)new StdSerializer<ConnectionCursor>(ConnectionCursor.class){

                public void serialize(ConnectionCursor value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                    gen.writeString(value.getValue());
                }
            });
        };
    }
}

