/*
 * Decompiled with CFR 0.152.
 */
package org.beast.graphql.configuration;

import java.lang.reflect.Field;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.beast.graphql.resolver.PageableMethodArgumentResolver;
import org.beast.graphql.resolver.SortMethodArgumentResolver;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.graphql.data.GraphQlArgumentBinder;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolverComposite;
import org.springframework.graphql.data.method.annotation.support.AnnotatedControllerConfigurer;
import org.springframework.graphql.data.method.annotation.support.ArgumentMapMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ArgumentMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ArgumentsMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.AuthenticationPrincipalArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ContextValueMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.DataFetchingEnvironmentMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.DataLoaderMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.LocalContextValueMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.PrincipalMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ProjectedPayloadMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.SourceMethodArgumentResolver;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@Configuration(proxyBeanMethods=false)
public class BeastGraphqlAutoConfiguration {
    private final ListableBeanFactory beanFactory;

    public BeastGraphqlAutoConfiguration(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Bean
    public PageableMethodArgumentResolver pageableMethodArgumentResolver() {
        return new PageableMethodArgumentResolver();
    }

    @Bean
    public SortMethodArgumentResolver sortMethodArgumentResolver() {
        return new SortMethodArgumentResolver();
    }

    @ConditionalOnMissingClass
    @Bean
    public Executor graphqlExecutor() {
        int nThreads = 5;
        CustomizableThreadFactory threadFactory = new CustomizableThreadFactory("pool-graphql-async-threads");
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)threadFactory);
    }

    @Bean
    public AnnotatedControllerConfigurer annotatedControllerConfigurer(final ObjectProvider<ConversionService> conversionService, final ObjectProvider<HandlerMethodArgumentResolver> provider, @Qualifier(value="graphqlExecutor") Executor executor) {
        AnnotatedControllerConfigurer registrar = new AnnotatedControllerConfigurer(){
            private final boolean springDataPresent = ClassUtils.isPresent((String)"org.springframework.data.projection.SpelAwareProxyProjectionFactory", (ClassLoader)AnnotatedControllerConfigurer.class.getClassLoader());
            private final boolean springSecurityPresent = ClassUtils.isPresent((String)"org.springframework.security.core.context.SecurityContext", (ClassLoader)AnnotatedControllerConfigurer.class.getClassLoader());

            public void afterPropertiesSet() {
                super.afterPropertiesSet();
                Field field = ReflectionUtils.findField(AnnotatedControllerConfigurer.class, (String)"argumentResolvers");
                Assert.notNull((Object)field, (String)"Reflection argumentResolvers field is not exists ");
                ReflectionUtils.makeAccessible((Field)field);
                HandlerMethodArgumentResolverComposite resolvers = new HandlerMethodArgumentResolverComposite();
                if (this.springDataPresent) {
                    resolvers.addResolver((HandlerMethodArgumentResolver)new ProjectedPayloadMethodArgumentResolver(this.obtainApplicationContext()));
                }
                resolvers.addResolver((HandlerMethodArgumentResolver)new ArgumentMapMethodArgumentResolver());
                GraphQlArgumentBinder argumentBinder = new GraphQlArgumentBinder((ConversionService)conversionService.getIfAvailable(DefaultFormattingConversionService::new));
                resolvers.addResolver((HandlerMethodArgumentResolver)new ArgumentMethodArgumentResolver(argumentBinder));
                resolvers.addResolver((HandlerMethodArgumentResolver)new ArgumentsMethodArgumentResolver(argumentBinder));
                resolvers.addResolver((HandlerMethodArgumentResolver)new ContextValueMethodArgumentResolver());
                resolvers.addResolver((HandlerMethodArgumentResolver)new LocalContextValueMethodArgumentResolver());
                provider.forEach(arg_0 -> ((HandlerMethodArgumentResolverComposite)resolvers).addResolver(arg_0));
                resolvers.addResolver((HandlerMethodArgumentResolver)new DataFetchingEnvironmentMethodArgumentResolver());
                resolvers.addResolver((HandlerMethodArgumentResolver)new DataLoaderMethodArgumentResolver());
                if (this.springSecurityPresent) {
                    resolvers.addResolver((HandlerMethodArgumentResolver)new PrincipalMethodArgumentResolver());
                    BeanFactoryResolver beanResolver = new BeanFactoryResolver((BeanFactory)this.obtainApplicationContext());
                    resolvers.addResolver((HandlerMethodArgumentResolver)new AuthenticationPrincipalArgumentResolver((BeanResolver)beanResolver));
                }
                resolvers.addResolver((HandlerMethodArgumentResolver)new SourceMethodArgumentResolver());
                ReflectionUtils.setField((Field)field, (Object)((Object)this), (Object)resolvers);
            }
        };
        registrar.setExecutor(executor);
        registrar.addFormatterRegistrar(registry -> ApplicationConversionService.addBeans((FormatterRegistry)registry, (ListableBeanFactory)this.beanFactory));
        return registrar;
    }
}

