package org.beast.graphql.data;




import org.springframework.lang.Nullable;

import java.util.List;
import java.util.stream.Collectors;

public class DefaultConnection<T>  {
    private List<Edge<T>> edges;

    private List<T> nodes;

    private PageInfo pageInfo;

    private @Nullable Long totalCount;

    public DefaultConnection(List<Edge<T>> edges, PageInfo pageInfo, @Nullable Long totalCount) {
        this.edges = edges;
        this.pageInfo = pageInfo;
        this.totalCount = totalCount;
        this.nodes = edges.stream().map(Edge::getNode).collect(Collectors.toList());
    }

    public DefaultConnection(List<Edge<T>> edges, PageInfo pageInfo) {
        this(edges, pageInfo, null);
    }


    public List<Edge<T>> getEdges() {
        return edges;
    }

    public List<T> getNodes() {
        return nodes;
    }

    public PageInfo getPageInfo() {
        return pageInfo;
    }

    @Nullable
    public Long getTotalCount() {
        return totalCount;
    }
}
