package org.beast.graphql.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.beast.data.domain.OrdersCursor;
import java.util.List;

public class ConnectionCursor extends OrdersCursor implements graphql.relay.ConnectionCursor {

    public ConnectionCursor(List<String> orders) {
        super(orders);
    }

    public ConnectionCursor(String rawValue) {
        super(rawValue);
    }

    public ConnectionCursor(OrdersCursor cursor) {
        super(cursor.getOrders());
    }


    @JsonCreator
    public static ConnectionCursor ofNullable(String rawValue) {
        if (rawValue == null) {
            return null;
        }
        return new ConnectionCursor(rawValue);
    }

    @Override
    public String getValue() {
        return super.getValue();
    }

}
