package org.beast.graphql.resolver;


import graphql.schema.DataFetchingEnvironment;
import org.beast.graphql.data.ConnectionCursor;
import org.beast.graphql.data.Pageable;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

import java.util.Optional;

public class PageableMethodArgumentResolver implements HandlerMethodArgumentResolver {

//    private final MessageConverterArgumentConverter argumentConverter;

    public PageableMethodArgumentResolver() {
//        this.argumentConverter = new MessageConverterArgumentConverter(converter);
    }

    @Override
    public boolean supportsParameter(@NonNull MethodParameter parameter) {
        return Pageable.class.equals(parameter.getParameterType());
    }

    @Nullable
    @Override
    public Object resolveArgument(@NonNull MethodParameter parameter, @NonNull DataFetchingEnvironment environment) throws Exception {
        ConnectionCursor after = ConnectionCursor.ofNullable(environment.getArgument("after"));
        ConnectionCursor before = ConnectionCursor.ofNullable(environment.getArgument("before"));
        Integer first = environment.getArgument("first");
        Integer last = environment.getArgument("last");
        Integer offset = environment.getArgument("offset");

        Boolean reverseBoolean = environment.getArgument("reverse");
        boolean reverse = Optional.ofNullable(reverseBoolean).orElse(false);
        Sort.Direction direction = reverse ? Sort.Direction.ASC : Sort.Direction.DESC;
        Sort sort = Sort.unsorted();
        String sortBy = environment.getArgument("sortBy");

        if (sortBy != null) {
            //默认降序
            sort = Sort.by(direction, sortBy);
        }

        return Pageable.of(after, before, first, last, offset, sort);
    }


//    private interface ArgumentConverter {
//
//        @Nullable
//        Object convert(Object rawValue, MethodParameter targetParameter) throws Exception;
//
//    }
//
//    private static class MessageConverterArgumentConverter implements ArgumentConverter {
//
//        private final GenericHttpMessageConverter<Object> converter;
//
//        public MessageConverterArgumentConverter(GenericHttpMessageConverter<Object> converter) {
//            this.converter = converter;
//        }
//
//        @Override
//        public Object convert(@NonNull Object rawValue, MethodParameter targetParameter) throws IOException {
//            HttpOutputMessageAdapter outMessage = new HttpOutputMessageAdapter();
//            this.converter.write(rawValue, MediaType.APPLICATION_JSON, outMessage);
//
//            HttpInputMessageAdapter inMessage = new HttpInputMessageAdapter(outMessage);
//            return this.converter.read(targetParameter.getGenericParameterType(), rawValue.getClass(), inMessage);
//        }
//    }
//
//    private static class HttpInputMessageAdapter extends ByteArrayInputStream implements HttpInputMessage {
//
//        HttpInputMessageAdapter(HttpOutputMessageAdapter messageAdapter) {
//            super(messageAdapter.toByteArray());
//        }
//
//        @NonNull
//        @Override
//        public InputStream getBody() {
//            return this;
//        }
//
//        @NonNull
//        @Override
//        public HttpHeaders getHeaders() {
//            return HttpHeaders.EMPTY;
//        }
//
//    }
//
//    private static class HttpOutputMessageAdapter extends ByteArrayOutputStream implements HttpOutputMessage {
//
//        private static final HttpHeaders noOpHeaders = new HttpHeaders();
//
//        @NonNull
//        @Override
//        public OutputStream getBody() {
//            return this;
//        }
//
//        @NonNull
//        @Override
//        public HttpHeaders getHeaders() {
//            return noOpHeaders;
//        }
//
//    }
}
