package org.beast.graphql.querydsl;


import com.querydsl.core.types.Predicate;
import org.beast.graphql.data.ConnectionCursor;
import org.beast.graphql.data.DefaultConnection;
import org.beast.graphql.data.Edge;
import org.beast.graphql.data.Pageable;
import org.springframework.data.domain.Sort;

import java.util.List;

public interface GraphqlQuerydslPredicateExecutor<T> {

    Iterable<T> findAll(Predicate predicate, Pageable pageable);

    List<Edge<T>> findAllEdge(Predicate predicate, Pageable pageable);

    Edge<T> findNextEdge(Predicate predicate, ConnectionCursor after, Sort sort);

    Edge<T> findPreviousEdge(Predicate predicate, ConnectionCursor before, Sort sort);


    DefaultConnection<T> connect(Predicate predicate, Pageable pageable);
}
