package org.beast.graphql.data;


import org.springframework.data.domain.Sort;

import java.util.Optional;

/**
 * first， last不同时支持？)
 * 基于光标分页
 * 基于offset分页   first-> limit  offset->offset
 * https://www.pdftron.com/blog/graphql/implementing-graphql-pagination/#offsetbased-pagination
 */
public class Pageable {


    //cursor依赖于sort解码
    private final ConnectionCursor after;
    private final ConnectionCursor before;

    private final Integer first;

    private final Integer last;

    private final Integer offset;

//    //颠倒
//    private final boolean reverse = false;
//
//    //排序字段(默认:升序)
//    private final String sortKey = null;
    private final Sort sort;

    private Pageable(ConnectionCursor after, ConnectionCursor before, Integer first, Integer last, Integer offset, Sort sort) {
        this.sort = sort;
        if (first != null && last != null) {
            throw new IllegalArgumentException("Passing both `first` and `last` to paginate connection is not supported.");
        }
        if (first != null && first < 0) {
            throw new IllegalArgumentException();
        }
        if (last != null && last < 0) {
            throw new IllegalArgumentException();
        }
//        if (offset != null && (after != null || before != null || last != null) ) {
//            throw new IllegalArgumentException("Passing both `offset` and `after, before, last` to paginate connection is not supported.");
//        }
        if (offset != null && last != null ) {
            throw new IllegalArgumentException("Passing both `offset` and `last` to paginate connection is not supported.");
        }
        this.after = after;
        this.before = before;
        this.first = first;
        this.last = last;
        this.offset = offset;
    }


    public static Pageable first(Integer first) {
        return Pageable.of(null, null, first, null, null);
    }

    public static Pageable last(Integer last) {
        return Pageable.of(null, null, null, last, null);
    }

    public static Pageable cursorBasedFirst(ConnectionCursor after, ConnectionCursor before, Integer first) {
        return Pageable.of(after, before,  first, null, null);
    }

    public static Pageable cursorBasedLast(ConnectionCursor after, ConnectionCursor before, Integer last) {
        return Pageable.of(after, before, null, last, null);
    }

    public static Pageable offsetBasedFirst(Integer offset, Integer last) {
        return Pageable.of(null, null, null, last, offset);
    }

    public static Pageable ofCursorBased(ConnectionCursor after, ConnectionCursor before, Integer first, Integer last) {
        return Pageable.of(after, before, first, last, null);
    }
    public static Pageable ofOffsetBased(Integer offset, Integer first) {
        return Pageable.of(null, null, first, null, offset);
    }

    public static Pageable of(ConnectionCursor after, ConnectionCursor before, Integer first, Integer last, Integer offset) {
        return new Pageable(after, before, first, last, offset, Sort.unsorted());
    }
    public static Pageable of(ConnectionCursor after, ConnectionCursor before, Integer first, Integer last, Integer offset, Sort sort) {
        return new Pageable(after, before, first, last, offset, sort);
    }

    public static Pageable of(Pageable pageable, Sort sort) {
        return Pageable.of(pageable.after, pageable.before, pageable.first, pageable.last, pageable.offset, sort);
    }

    public static Pageable empty() {
        return Pageable.of(null, null, null, null, null, null);
    }

    public Pageable with(Sort sort) {
        return Pageable.of(this, sort);
    }

    public Integer getFirst() {
        return first;
    }
    public Optional<Integer> getFirstOptional() {
        return Optional.ofNullable(first);
    }

    public Integer getLast() {
        return last;
    }

    public Optional<Integer> getLastOptional() {
        return Optional.ofNullable(last);
    }

    public ConnectionCursor getAfter() {
        return after;
    }

    public Optional<ConnectionCursor> getAfterOptional() {
        return Optional.ofNullable(after);
    }

    public ConnectionCursor getBefore() {
        return before;
    }
    public Optional<ConnectionCursor> getBeforeOptional() {
        return Optional.ofNullable(before);
    }
    public Integer getOffset() {
        return offset;
    }
    public Optional<Integer> getOffsetOptional() {
        return Optional.ofNullable(offset);
    }

    public Sort getSort() {
        return sort;
    }
}
