package org.beast.graphql.data;

import lombok.Getter;


@Getter
public class PageInfo implements graphql.relay.PageInfo {

    private final ConnectionCursor startCursor;
    private final ConnectionCursor endCursor;
    private final Boolean hasPreviousPage;
    private final Boolean hasNextPage;

    public PageInfo(
            ConnectionCursor startCursor,
            ConnectionCursor endCursor,
            Boolean hasPreviousPage,
            Boolean hasNextPage
    ) {
        this.startCursor = startCursor;
        this.endCursor = endCursor;
        this.hasPreviousPage = hasPreviousPage;
        this.hasNextPage = hasNextPage;
    }

    @Override
    public boolean isHasPreviousPage() {
        return hasPreviousPage;
    }

    @Override
    public boolean isHasNextPage() {
        return hasNextPage;
    }
}
