package org.beast.graphql.data;

import java.util.Optional;

public class CursorRange {
    private final static CursorRange UNBOUNDED = CursorRange.of(null, null);
    private final ConnectionCursor after;

    private final ConnectionCursor before;

    public CursorRange(ConnectionCursor after, ConnectionCursor before) {
        this.after = after;
        this.before = before;
    }

    public static CursorRange unbounded() {
        return UNBOUNDED;
    }


    public static CursorRange of(ConnectionCursor after, ConnectionCursor before) {
        return new CursorRange(
                after,
                before
        );
    }


    public Optional<ConnectionCursor> getAfter() {
        return Optional.ofNullable(after);
    }

    public Optional<ConnectionCursor> getBefore() {
        return Optional.ofNullable(before);
    }
}
