package org.beast.graphql.configuration;

import org.beast.graphql.resolver.PageableMethodArgumentResolver;
import org.beast.graphql.resolver.SortMethodArgumentResolver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.graphql.data.GraphQlArgumentBinder;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolverComposite;
import org.springframework.graphql.data.method.annotation.support.*;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;

@AutoConfigureAfter({ WebMvcAutoConfiguration.class })
@Configuration(proxyBeanMethods = false)
public class BeastGraphqlAutoConfiguration {

    @Bean
    public PageableMethodArgumentResolver pageableMethodArgumentResolver() {
        return new PageableMethodArgumentResolver();
    }

    @Bean
    public SortMethodArgumentResolver sortMethodArgumentResolver() {
        return new SortMethodArgumentResolver();
    }

    //TODO 这边忘了修改了什么 不知道会不会有问题，可能是自定义HandlerMethodArgumentResolver的支持,新版可能支持了
    @Bean
    public AnnotatedControllerConfigurer annotatedControllerConfigurer(
            ObjectProvider<ConversionService> conversionService,
            ObjectProvider<HandlerMethodArgumentResolver> provider
    ) {
//        GenericHttpMessageConverter<Object> jsonMessageConverter = getJsonConverter(converters);
        AnnotatedControllerConfigurer registrar = new AnnotatedControllerConfigurer() {
            private final boolean springDataPresent = ClassUtils.isPresent(
                    "org.springframework.data.projection.SpelAwareProxyProjectionFactory",
                    AnnotatedControllerConfigurer.class.getClassLoader());
            private final boolean springSecurityPresent = ClassUtils.isPresent(
                    "org.springframework.security.core.context.SecurityContext",
                    AnnotatedControllerConfigurer.class.getClassLoader());

            @Override
            public void afterPropertiesSet() {
                //TODO 重设了afterPropertiesSet
                super.afterPropertiesSet();
                Field field = ReflectionUtils.findField(AnnotatedControllerConfigurer.class, "argumentResolvers");
                Assert.notNull(field, "Reflection argumentResolvers field is not exists ");
                ReflectionUtils.makeAccessible(field);

                HandlerMethodArgumentResolverComposite argumentResolvers = new HandlerMethodArgumentResolverComposite();

                // Annotation based
                if (springDataPresent) {
                    // Must be ahead of ArgumentMethodArgumentResolver
                    argumentResolvers.addResolver(new ProjectedPayloadMethodArgumentResolver(obtainApplicationContext()));
                }
                argumentResolvers.addResolver(new ArgumentMapMethodArgumentResolver());
                GraphQlArgumentBinder argumentBinder = new GraphQlArgumentBinder(conversionService.getIfAvailable(DefaultFormattingConversionService::new));
                argumentResolvers.addResolver(new ArgumentMethodArgumentResolver(argumentBinder));
                argumentResolvers.addResolver(new ArgumentsMethodArgumentResolver(argumentBinder));
                argumentResolvers.addResolver(new ContextValueMethodArgumentResolver());

                provider.forEach(argumentResolvers::addResolver);

                // Type based
                argumentResolvers.addResolver(new DataFetchingEnvironmentMethodArgumentResolver());
                argumentResolvers.addResolver(new DataLoaderMethodArgumentResolver());
                if (springSecurityPresent) {
                    argumentResolvers.addResolver(new PrincipalMethodArgumentResolver());
                    BeanResolver beanResolver = new BeanFactoryResolver(obtainApplicationContext());
                    argumentResolvers.addResolver(new AuthenticationPrincipalArgumentResolver(beanResolver));
                }
//                if (KotlinDetector.isKotlinPresent()) {
//                    argumentResolvers.addResolver(new ContinuationHandlerMethodArgumentResolver());
//                }

                // This works as a fallback, after other resolvers
                argumentResolvers.addResolver(new SourceMethodArgumentResolver());
                ReflectionUtils.setField(field, this, argumentResolvers);
            }
        };
//        registrar.setJsonMessageConverter(jsonMessageConverter);
        return registrar;
    }

}
