/*
 * Decompiled with CFR 0.152.
 */
package org.beast.graphql.resolver;

import graphql.schema.DataFetchingEnvironment;
import java.lang.annotation.Annotation;
import org.springframework.core.MethodParameter;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractTokenArgumentResolver<A extends Annotation>
implements HandlerMethodArgumentResolver {
    private Class<A> annotationClass;

    public AbstractTokenArgumentResolver(Class<A> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public boolean supportsParameter(@NonNull MethodParameter parameter) {
        return parameter.hasParameterAnnotation(this.annotationClass);
    }

    public abstract boolean isRequired(A var1);

    @Nullable
    public Object resolveArgument(@NonNull MethodParameter parameter, @NonNull DataFetchingEnvironment environment) throws Exception {
        MethodParameter nestedParameter;
        Object arg;
        Annotation annotation = parameter.getParameterAnnotation(this.annotationClass);
        Assert.state((annotation != null ? 1 : 0) != 0, (String)("No " + this.annotationClass.getSimpleName() + " annotation"));
        String name = parameter.getParameterName();
        if (name == null) {
            name = "";
        }
        if ((arg = this.resolveValue(nestedParameter = parameter.nestedIfOptional(), environment)) == null) {
            if (this.isRequired(annotation) && !nestedParameter.isOptional()) {
                this.handleMissingValue(parameter);
            }
            arg = this.handleNullValue(arg, nestedParameter.getNestedParameterType());
        }
        return arg;
    }

    protected abstract void handleMissingValue(MethodParameter var1);

    @Nullable
    private Object handleNullValue(@Nullable Object value, Class<?> paramType) {
        if (value == null && Boolean.TYPE.equals(paramType)) {
            return Boolean.FALSE;
        }
        return value;
    }

    @Nullable
    protected abstract Object resolveValue(MethodParameter var1, DataFetchingEnvironment var2);
}

