/*
 * Decompiled with CFR 0.152.
 */
package org.beast.graphql.experimental;

import graphql.GraphQL;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.ResourceLoader;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.boot.GraphQlAutoConfiguration;
import org.springframework.graphql.boot.GraphQlProperties;
import org.springframework.graphql.data.method.annotation.support.AnnotatedControllerConfigurer;
import org.springframework.graphql.execution.BatchLoaderRegistry;
import org.springframework.graphql.execution.DefaultBatchLoaderRegistry;
import org.springframework.graphql.execution.DefaultExecutionGraphQlService;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.execution.ThreadLocalAccessor;
import org.springframework.graphql.web.WebGraphQlHandler;
import org.springframework.graphql.web.WebGraphQlHandlerInterceptor;
import org.springframework.graphql.web.webmvc.GraphQlHttpHandler;
import org.springframework.graphql.web.webmvc.GraphiQlHandler;
import org.springframework.graphql.web.webmvc.SchemaHandler;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.function.RequestPredicates;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerResponse;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={GraphQL.class, GraphQlHttpHandler.class})
@AutoConfigureAfter(value={GraphQlAutoConfiguration.class})
public class ExtGraphQlWebMvcAutoConfiguration {
    private static final Log logger = LogFactory.getLog(ExtGraphQlWebMvcAutoConfiguration.class);
    private final BatchLoaderRegistry batchLoaderRegistry = new DefaultBatchLoaderRegistry();

    public ExtGraphQlWebMvcAutoConfiguration() {
        logger.info((Object)"ExtGraphQlWebMvcAutoConfiguration loaded");
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQlHttpHandler graphQlHttpHandler(WebGraphQlHandler webGraphQlHandler) {
        return new GraphQlHttpHandler(webGraphQlHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    public BatchLoaderRegistry batchLoaderRegistry() {
        return this.batchLoaderRegistry;
    }

    @Bean
    @ConditionalOnMissingBean
    public AnnotatedControllerConfigurer annotatedControllerConfigurer() {
        AnnotatedControllerConfigurer annotatedControllerConfigurer = new AnnotatedControllerConfigurer();
        annotatedControllerConfigurer.setConversionService((ConversionService)new DefaultFormattingConversionService());
        return annotatedControllerConfigurer;
    }

    @Bean
    @ConditionalOnMissingBean
    public WebGraphQlHandler webGraphQlHandler(ExecutionGraphQlService service, ObjectProvider<WebGraphQlHandlerInterceptor> interceptorsProvider, ObjectProvider<ThreadLocalAccessor> accessorsProvider) {
        return WebGraphQlHandler.builder((ExecutionGraphQlService)service).interceptors(interceptorsProvider.orderedStream().collect(Collectors.toList())).threadLocalAccessors(accessorsProvider.orderedStream().collect(Collectors.toList())).build();
    }

    @Bean
    public DefaultExecutionGraphQlService executionGraphQlService(GraphQlSource graphQlSource) {
        return new DefaultExecutionGraphQlService(graphQlSource);
    }

    @Bean
    public RouterFunction<ServerResponse> graphQlRouterFunction(GraphQlHttpHandler handler, GraphQlSource graphQlSource, GraphQlProperties properties, ResourceLoader resourceLoader) {
        String graphQLPath = properties.getPath();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("GraphQL endpoint HTTP POST " + graphQLPath));
        }
        RouterFunctions.Builder builder = RouterFunctions.route().GET(graphQLPath, request -> ((ServerResponse.BodyBuilder)ServerResponse.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).headers(headers -> headers.setAllow(Collections.singleton(HttpMethod.POST)))).build()).POST(graphQLPath, RequestPredicates.contentType((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON}).and(RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON})), arg_0 -> ((GraphQlHttpHandler)handler).handleRequest(arg_0));
        if (properties.getGraphiql().isEnabled()) {
            GraphiQlHandler graphiQLHandler = new GraphiQlHandler(graphQLPath, "");
            builder = builder.GET(properties.getGraphiql().getPath(), arg_0 -> ((GraphiQlHandler)graphiQLHandler).handleRequest(arg_0));
        }
        if (properties.getSchema().getPrinter().isEnabled()) {
            SchemaHandler schemaHandler = new SchemaHandler(graphQlSource);
            builder = builder.GET(graphQLPath + "/schema", arg_0 -> ((SchemaHandler)schemaHandler).handleRequest(arg_0));
        }
        return builder.build();
    }
}

