/*
 * Decompiled with CFR 0.152.
 */
package org.beast.graphql.data;

import java.util.List;
import java.util.stream.Collectors;
import org.beast.graphql.data.Edge;
import org.beast.graphql.data.PageInfo;
import org.springframework.lang.Nullable;

public class DefaultConnection<T> {
    private List<Edge<T>> edges;
    private List<T> nodes;
    private PageInfo pageInfo;
    @Nullable
    private Long totalCount;

    public DefaultConnection(List<Edge<T>> edges, PageInfo pageInfo, @Nullable Long totalCount) {
        this.edges = edges;
        this.pageInfo = pageInfo;
        this.totalCount = totalCount;
        this.nodes = edges.stream().map(Edge::getNode).collect(Collectors.toList());
    }

    public DefaultConnection(List<Edge<T>> edges, PageInfo pageInfo) {
        this(edges, pageInfo, null);
    }

    public List<Edge<T>> getEdges() {
        return this.edges;
    }

    public List<T> getNodes() {
        return this.nodes;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    @Nullable
    public Long getTotalCount() {
        return this.totalCount;
    }
}

