/*
 * Decompiled with CFR 0.152.
 */
package org.beast.graphql.configuration;

import java.lang.reflect.Field;
import org.beast.graphql.resolver.PageableMethodArgumentResolver;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.graphql.data.GraphQlArgumentInitializer;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolverComposite;
import org.springframework.graphql.data.method.annotation.support.AnnotatedControllerConfigurer;
import org.springframework.graphql.data.method.annotation.support.ArgumentMapMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ArgumentMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.AuthenticationPrincipalArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ContextValueMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.DataFetchingEnvironmentMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.DataLoaderMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.PrincipalMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ProjectedPayloadMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.SourceMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@Configuration(proxyBeanMethods=false)
public class BeastGraphqlAutoConfiguration {
    @Bean
    public PageableMethodArgumentResolver pageableMethodArgumentResolver() {
        return new PageableMethodArgumentResolver();
    }

    @Bean
    public AnnotatedControllerConfigurer annotatedControllerConfigurer(final ObjectProvider<ConversionService> conversionService, final ObjectProvider<HandlerMethodArgumentResolver> provider) {
        AnnotatedControllerConfigurer registrar = new AnnotatedControllerConfigurer(){
            private final boolean springDataPresent = ClassUtils.isPresent((String)"org.springframework.data.projection.SpelAwareProxyProjectionFactory", (ClassLoader)AnnotatedControllerConfigurer.class.getClassLoader());
            private final boolean springSecurityPresent = ClassUtils.isPresent((String)"org.springframework.security.core.context.SecurityContext", (ClassLoader)AnnotatedControllerConfigurer.class.getClassLoader());

            public void afterPropertiesSet() {
                super.afterPropertiesSet();
                Field field = ReflectionUtils.findField(AnnotatedControllerConfigurer.class, (String)"argumentResolvers");
                Assert.notNull((Object)field, (String)"Reflection argumentResolvers field is not exists ");
                ReflectionUtils.makeAccessible((Field)field);
                HandlerMethodArgumentResolverComposite argumentResolvers = new HandlerMethodArgumentResolverComposite();
                if (this.springDataPresent) {
                    argumentResolvers.addResolver((HandlerMethodArgumentResolver)new ProjectedPayloadMethodArgumentResolver(this.obtainApplicationContext()));
                }
                argumentResolvers.addResolver((HandlerMethodArgumentResolver)new ArgumentMapMethodArgumentResolver());
                GraphQlArgumentInitializer initializer = new GraphQlArgumentInitializer((ConversionService)conversionService.getIfAvailable(DefaultConversionService::new));
                argumentResolvers.addResolver((HandlerMethodArgumentResolver)new ArgumentMethodArgumentResolver(initializer));
                argumentResolvers.addResolver((HandlerMethodArgumentResolver)new ContextValueMethodArgumentResolver());
                provider.forEach(arg_0 -> ((HandlerMethodArgumentResolverComposite)argumentResolvers).addResolver(arg_0));
                argumentResolvers.addResolver((HandlerMethodArgumentResolver)new DataFetchingEnvironmentMethodArgumentResolver());
                argumentResolvers.addResolver((HandlerMethodArgumentResolver)new DataLoaderMethodArgumentResolver());
                if (this.springSecurityPresent) {
                    argumentResolvers.addResolver((HandlerMethodArgumentResolver)new PrincipalMethodArgumentResolver());
                    BeanFactoryResolver beanResolver = new BeanFactoryResolver((BeanFactory)this.obtainApplicationContext());
                    argumentResolvers.addResolver((HandlerMethodArgumentResolver)new AuthenticationPrincipalArgumentResolver((BeanResolver)beanResolver));
                }
                argumentResolvers.addResolver((HandlerMethodArgumentResolver)new SourceMethodArgumentResolver());
                ReflectionUtils.setField((Field)field, (Object)((Object)this), (Object)argumentResolvers);
            }
        };
        return registrar;
    }
}

