/*
 * Decompiled with CFR 0.152.
 */
package org.beast.graphql.querydsl;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.beast.data.domain.OrdersCursor;
import org.beast.data.querydsl.CursorEncoder;
import org.beast.data.querydsl.CursorPredicateFactory;
import org.beast.graphql.data.ConnectionCursor;
import org.beast.graphql.data.DefaultEdge;
import org.beast.graphql.data.Edge;
import org.beast.graphql.data.Pageable;
import org.beast.graphql.querydsl.GraphqlQuerydslPredicateExecutor;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.support.MappingMongoEntityInformation;
import org.springframework.data.mongodb.repository.support.SpringDataMongodbQuery;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QSort;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class GraphqlQuerydslMongoPredicateExecutor<T>
implements GraphqlQuerydslPredicateExecutor<T> {
    private final PathBuilder<T> builder;
    private final MappingMongoEntityInformation<T, ?> entityInformation;
    private final TypeInformation<T> typeInformation;
    private final MongoOperations mongoOperations;
    private CursorEncoder cursorEncoder;
    private final CursorPredicateFactory cursorPredicateFactory;

    public GraphqlQuerydslMongoPredicateExecutor(MappingMongoEntityInformation<T, ?> entityInformation, MongoOperations mongoOperations, CursorPredicateFactory cursorPredicateFactory, CursorEncoder cursorEncoder) {
        this(entityInformation, mongoOperations, (EntityPathResolver)SimpleEntityPathResolver.INSTANCE, cursorPredicateFactory);
        this.cursorEncoder = cursorEncoder;
    }

    public GraphqlQuerydslMongoPredicateExecutor(MappingMongoEntityInformation<T, ?> entityInformation, MongoOperations mongoOperations, EntityPathResolver resolver, CursorPredicateFactory cursorPredicateFactory) {
        this.entityInformation = entityInformation;
        this.cursorPredicateFactory = cursorPredicateFactory;
        this.builder = GraphqlQuerydslMongoPredicateExecutor.pathBuilderFor(resolver.createPath(entityInformation.getJavaType()));
        this.mongoOperations = mongoOperations;
        this.typeInformation = ClassTypeInformation.from((Class)this.entityInformation.getJavaType());
    }

    protected static <E> PathBuilder<E> pathBuilderFor(EntityPath<E> path) {
        return new PathBuilder(path.getType(), path.getMetadata());
    }

    @Override
    public Iterable<T> findAll(Predicate predicate, Pageable pageable) {
        return this.findAllEdge(predicate, pageable).stream().map(Edge::getNode).collect(Collectors.toList());
    }

    @Override
    public List<Edge<T>> findAllEdge(Predicate predicate, Pageable pageable) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        SpringDataMongodbQuery<T> query = this.createQueryFor(predicate);
        Sort sort = pageable.getSort();
        return this.applyPagination(query, pageable).fetch().stream().map(node -> {
            ConnectionCursor cursor = new ConnectionCursor(this.cursorEncoder.encode(this.typeInformation, sort, node));
            return new DefaultEdge<Object>(node, cursor);
        }).collect(Collectors.toList());
    }

    @Override
    public Edge<T> findNextEdge(Predicate predicate, ConnectionCursor after, Sort sort) {
        SpringDataMongodbQuery<T> query = this.createQueryFor(predicate);
        query = this.applyAfter(query, after, sort);
        Object node = ((SpringDataMongodbQuery)query.limit(1L)).fetchFirst();
        ConnectionCursor cursor = new ConnectionCursor(this.cursorEncoder.encode(this.typeInformation, sort, node));
        return new DefaultEdge<Object>(node, cursor);
    }

    @Override
    public Edge<T> findPreviousEdge(Predicate predicate, ConnectionCursor before, Sort sort) {
        SpringDataMongodbQuery<T> query = this.createQueryFor(predicate);
        query = this.applyBefore(query, before, sort);
        Object node = ((SpringDataMongodbQuery)query.limit(1L)).fetchFirst();
        ConnectionCursor cursor = new ConnectionCursor(this.cursorEncoder.encode(this.typeInformation, sort, node));
        return new DefaultEdge<Object>(node, cursor);
    }

    protected EntityInformation<T, ?> typeInformation() {
        return this.entityInformation;
    }

    private SpringDataMongodbQuery<T> createQueryFor(Predicate predicate) {
        return (SpringDataMongodbQuery)this.createQuery().where(predicate);
    }

    private SpringDataMongodbQuery<T> createQuery() {
        return new SpringDataMongodbQuery(this.mongoOperations, this.typeInformation().getJavaType());
    }

    private SpringDataMongodbQuery<T> applyAfter(SpringDataMongodbQuery<T> query, ConnectionCursor cursor, Sort sort) {
        Predicate predicate = this.cursorPredicateFactory.after(this.typeInformation, (OrdersCursor)cursor, sort);
        if (predicate != null) {
            query = (SpringDataMongodbQuery)query.where(predicate);
        }
        return query;
    }

    private SpringDataMongodbQuery<T> applyBefore(SpringDataMongodbQuery<T> query, ConnectionCursor cursor, Sort sort) {
        Predicate predicate = this.cursorPredicateFactory.before(this.typeInformation, (OrdersCursor)cursor, sort);
        if (predicate != null) {
            query = (SpringDataMongodbQuery)query.where(predicate);
        }
        return query;
    }

    private SpringDataMongodbQuery<T> applyPagination(SpringDataMongodbQuery<T> query, Pageable pageable) {
        Optional<ConnectionCursor> afterOptional = pageable.getAfterOptional();
        Optional<ConnectionCursor> beforeOptional = pageable.getBeforeOptional();
        Sort sort = pageable.getSort();
        if (afterOptional.isPresent()) {
            query = this.applyAfter(query, afterOptional.get(), sort);
        }
        if (beforeOptional.isPresent()) {
            query = this.applyBefore(query, beforeOptional.get(), sort);
        }
        Optional<Integer> offsetOptional = pageable.getOffsetOptional();
        Optional<Integer> firstOptional = pageable.getFirstOptional();
        Optional<Integer> lastOptional = pageable.getLastOptional();
        if (lastOptional.isPresent()) {
            long count = query.fetchCount();
            int last = lastOptional.get();
            int offset = offsetOptional.orElse(0);
            query = (SpringDataMongodbQuery)((SpringDataMongodbQuery)query.offset(count - (long)last + (long)offset)).limit((long)last);
        } else {
            offsetOptional.ifPresent(arg_0 -> query.offset(arg_0));
            firstOptional.ifPresent(arg_0 -> query.limit(arg_0));
        }
        return this.applySorting(query, pageable.getSort());
    }

    private SpringDataMongodbQuery<T> applySorting(SpringDataMongodbQuery<T> query, Sort sort) {
        this.toOrderSpecifiers(sort).forEach(arg_0 -> query.orderBy(arg_0));
        return query;
    }

    protected List<OrderSpecifier<?>> toOrderSpecifiers(Sort sort) {
        if (sort instanceof QSort) {
            return ((QSort)sort).getOrderSpecifiers();
        }
        return sort.stream().map(this::toOrder).collect(Collectors.toList());
    }

    protected OrderSpecifier<?> toOrder(Sort.Order order) {
        PathBuilder property = this.builder.get(order.getProperty());
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, (Expression)property);
    }
}

