/*
 * Decompiled with CFR 0.152.
 */
package org.beast.graphql.data.querydsl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.querydsl.core.types.Predicate;
import graphql.Assert;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.beast.graphql.data.Edge;
import org.beast.graphql.data.PageInfo;
import org.beast.graphql.data.Pageable;
import org.springframework.lang.Nullable;

public class PredicateConnection<T> {
    private Predicate predicate;
    private Pageable pageable;
    private final ImmutableList<T> nodes;
    private final ImmutableList<Edge<T>> edges;
    private final PageInfo pageInfo;

    public PredicateConnection(Predicate predicate, Pageable pageable, List<Edge<T>> edges) {
        this(predicate, pageable, edges, null, null);
    }

    public PredicateConnection(Predicate predicate, Pageable pageable, List<Edge<T>> edges, @Nullable Boolean hasPreviousPage, @Nullable Boolean hasNextPage) {
        Assert.assertNotNull(edges, () -> "edges cannot be null");
        this.predicate = predicate;
        this.pageable = pageable;
        this.nodes = ImmutableList.copyOf((Collection)edges.stream().map(Edge::getNode).collect(Collectors.toList()));
        this.edges = ImmutableList.copyOf(edges);
        this.pageInfo = this.buildPageInfo((Edge)Iterables.getFirst(edges, null), (Edge)Iterables.getLast(edges, null), hasPreviousPage, hasNextPage);
    }

    public PageInfo buildPageInfo(Edge<T> start, Edge<T> end, Boolean hasPreviousPage, Boolean hasNextPage) {
        return new PageInfo(start != null ? start.getCursor() : null, end != null ? end.getCursor() : null, hasPreviousPage, hasNextPage);
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    public ImmutableList<T> getNodes() {
        return this.nodes;
    }

    public ImmutableList<Edge<T>> getEdges() {
        return this.edges;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }
}

