package org.beast.exporter;

import lombok.extern.slf4j.Slf4j;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Iterator;


@Slf4j
public abstract class AbstractExporter<T> implements Flushable {

    private int writeCount;

    private static final int BLOCK_SIZE = 100;

    public AbstractExporter() {
        this.writeCount = 0;
    }


    public void write(
            Iterator<T> iterator
    ) throws IOException {
        try {
            while (iterator.hasNext()) {
                T value = iterator.next();
                writeObject(value);
                writeCount++;
                if (writeCount % BLOCK_SIZE == 0) {
                    flush();
                }
            }
            flush();
        } finally {
            if (iterator instanceof Closeable) {
                ((Closeable) iterator).close();
            }
        }
    }

    public abstract void writeObject(T object) throws IOException;
}
