/*
 * Decompiled with CFR 0.152.
 */
package org.beast.exporter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.beast.exporter.AbstractExporter;

public abstract class CSVFileExporter<T>
extends AbstractExporter<T> {
    private CSVPrinter printer;

    public CSVFileExporter(OutputStream os, boolean withBOM) throws IOException {
        if (withBOM) {
            this.writeBOM(os);
        }
        OutputStreamWriter writer = new OutputStreamWriter(os);
        CSVFormat format = CSVFormat.DEFAULT.withHeader(new String[0]);
        this.printer = new CSVPrinter((Appendable)writer, format);
    }

    private void writeBOM(OutputStream os) throws IOException {
        os.write(new byte[]{-17, -69, -65});
    }

    @Override
    public void flush() throws IOException {
        this.printer.flush();
    }

    @Override
    public void writeObject(T object) throws IOException {
        List<String> row = this.apply(object);
        this.printer.printRecord(row);
    }

    public abstract List<String> apply(T var1);
}

