package org.beast.data.redis.ser;


import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.format.datetime.standard.InstantFormatter;

import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.Instant;

public class InstantRedisSerializer implements RedisSerializer<Instant> {

    private InstantFormatter formatter = new InstantFormatter();

    @Override
    public byte[] serialize(Instant instant) throws SerializationException {
        if (instant == null)  {
            return null;
        }
        String time = formatter.print(instant, null);
        return time.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Instant deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null)  {
            return null;
        }
        String time = new String(bytes, StandardCharsets.UTF_8);
        try {
            return formatter.parse(time, null);
        } catch (ParseException e) {
            throw new SerializationException("serialization exception", e);
        }
    }
}
