/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.querydsl;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.querydsl.binding.CustomQuerydslPredicateBuilder;
import org.springframework.data.querydsl.binding.QuerydslBindings;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.querydsl.binding.QuerydslPredicateBuilder;
import org.springframework.data.util.CastUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.data.web.querydsl.QuerydslPredicateArgumentResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class CustomQuerydslPredicateArgumentResolver
extends QuerydslPredicateArgumentResolver {
    private static final ResolvableType PREDICATE = ResolvableType.forClass(Predicate.class);
    private static final ResolvableType OPTIONAL_OF_PREDICATE = ResolvableType.forClassWithGenerics(Optional.class, (ResolvableType[])new ResolvableType[]{PREDICATE});
    private final QuerydslBindingsFactory bindingsFactory;
    private final QuerydslPredicateBuilder predicateBuilder;

    public CustomQuerydslPredicateArgumentResolver(QuerydslBindingsFactory factory, Optional<ConversionService> conversionService) {
        super(factory, conversionService);
        this.bindingsFactory = factory;
        this.predicateBuilder = new CustomQuerydslPredicateBuilder(conversionService.orElseGet(DefaultConversionService::new), factory.getEntityPathResolver());
    }

    @Nullable
    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        MultiValueMap<String, String> queryParameters = CustomQuerydslPredicateArgumentResolver.getQueryParameters(webRequest);
        Optional<QuerydslPredicate> annotation = Optional.ofNullable((QuerydslPredicate)parameter.getParameterAnnotation(QuerydslPredicate.class));
        TypeInformation domainType = CustomQuerydslPredicateArgumentResolver.extractTypeInfo(parameter).getRequiredActualType();
        Optional<Class> bindingsAnnotation = annotation.map(QuerydslPredicate::bindings).map(CastUtils::cast);
        QuerydslBindings bindings = bindingsAnnotation.map(it -> this.bindingsFactory.createBindingsFor(domainType, it)).orElseGet(() -> this.bindingsFactory.createBindingsFor(domainType));
        Predicate result = this.predicateBuilder.getPredicate(domainType, queryParameters, bindings);
        if (!parameter.isOptional() && result == null) {
            return new BooleanBuilder();
        }
        return OPTIONAL_OF_PREDICATE.isAssignableFrom(ResolvableType.forMethodParameter((MethodParameter)parameter)) ? Optional.ofNullable(result) : result;
    }

    private static MultiValueMap<String, String> getQueryParameters(NativeWebRequest webRequest) {
        Map parameterMap = webRequest.getParameterMap();
        LinkedMultiValueMap queryParameters = new LinkedMultiValueMap(parameterMap.size());
        for (Map.Entry entry : parameterMap.entrySet()) {
            queryParameters.put((Object)((String)entry.getKey()), Arrays.asList((String[])entry.getValue()));
        }
        return queryParameters;
    }

    static TypeInformation<?> extractTypeInfo(MethodParameter parameter) {
        Optional<QuerydslPredicate> annotation = Optional.ofNullable((QuerydslPredicate)parameter.getParameterAnnotation(QuerydslPredicate.class));
        return annotation.filter(it -> !Object.class.equals((Object)it.root())).map(it -> ClassTypeInformation.from((Class)it.root())).orElseGet(() -> CustomQuerydslPredicateArgumentResolver.detectDomainType(parameter));
    }

    private static TypeInformation<?> detectDomainType(MethodParameter parameter) {
        Method method = parameter.getMethod();
        if (method == null) {
            throw new IllegalArgumentException("Method parameter is not backed by a method!");
        }
        return CustomQuerydslPredicateArgumentResolver.detectDomainType(ClassTypeInformation.fromReturnTypeOf((Method)method));
    }

    private static TypeInformation<?> detectDomainType(TypeInformation<?> source) {
        if (source.getTypeArguments().isEmpty()) {
            return source;
        }
        TypeInformation actualType = source.getActualType();
        if (actualType == null) {
            throw new IllegalArgumentException(String.format("Could not determine domain type from %s!", source));
        }
        if (source != actualType) {
            return CustomQuerydslPredicateArgumentResolver.detectDomainType(actualType);
        }
        if (source instanceof Iterable) {
            return source;
        }
        return CustomQuerydslPredicateArgumentResolver.detectDomainType(source.getRequiredComponentType());
    }
}

