/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.querydsl;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.beast.data.querydsl.CursorEncoder;
import org.beast.data.relay.Cursor;
import org.beast.data.relay.DefaultCursor;
import org.beast.data.relay.RawCursor;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.Property;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.annotation.Id;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class CursorPredicateFactory {
    private final ConversionService conversionService;
    private final EntityPathResolver resolver;

    public CursorPredicateFactory(ConversionService conversionService, EntityPathResolver resolver, CursorEncoder encoder) {
        this.conversionService = conversionService;
        this.resolver = resolver;
    }

    private Predicate predicate(Class<?> clazz, Sort sort, RawCursor cursor, Direction direction) {
        ClassTypeInformation typeInformation = ClassTypeInformation.from(clazz);
        return this.predicate((TypeInformation<?>)typeInformation, sort, cursor, direction);
    }

    @Nullable
    public <T> Predicate before(TypeInformation<T> typeInformation, Sort sort, Cursor cursor) {
        return this.predicate(typeInformation, sort, cursor, Direction.BEFORE);
    }

    @Nullable
    public Predicate before(Class<?> clazz, Sort sort, RawCursor cursor) {
        return this.predicate(clazz, sort, cursor, Direction.BEFORE);
    }

    @Nullable
    public Predicate before(Class<?> clazz, Sort sort, Cursor cursor) {
        ClassTypeInformation typeInformation = ClassTypeInformation.from(clazz);
        return this.predicate((TypeInformation<?>)typeInformation, sort, cursor, Direction.BEFORE);
    }

    @Nullable
    public Predicate after(Class<?> clazz, Sort sort, RawCursor cursor) {
        return this.predicate(clazz, sort, cursor, Direction.AFTER);
    }

    @Nullable
    public <T> Predicate after(Class<T> clazz, Sort sort, Cursor cursor) {
        ClassTypeInformation typeInformation = ClassTypeInformation.from(clazz);
        return this.predicate((TypeInformation<?>)typeInformation, sort, cursor, Direction.AFTER);
    }

    @Nullable
    public <T> Predicate after(TypeInformation<T> typeInformation, Sort sort, Cursor cursor) {
        return this.predicate(typeInformation, sort, cursor, Direction.AFTER);
    }

    private Predicate predicate(TypeInformation<?> typeInformation, Sort sort, Cursor cursor, Direction direction) {
        List cursors = DefaultCursor.decode((String)cursor.getValue());
        ArrayList<Object> orderValues = new ArrayList<Object>(cursors.size());
        int i = 0;
        for (Sort.Order order : sort) {
            Object value;
            String property = order.getProperty();
            PropertyPath path = this.getPropertyPath(property, typeInformation);
            if (path == null) {
                throw new IllegalArgumentException(String.format("sort property: %s is miss", property));
            }
            String entryValue = (String)cursors.get(i);
            try {
                value = this.convertToPropertyPathSpecificType(entryValue, path);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("'%s' does conversion failed", path), e);
            }
            orderValues.add(value);
            ++i;
        }
        RawCursor rawCursor = new RawCursor(orderValues.toArray());
        return this.predicate(typeInformation, sort, rawCursor, direction);
    }

    @Nullable
    private Predicate predicate(TypeInformation<?> typeInformation, Sort sort, RawCursor cursor, Direction direction) {
        BooleanBuilder builder = new BooleanBuilder();
        if (cursor == null) {
            return builder.getValue();
        }
        BooleanBuilder basePredicate = new BooleanBuilder();
        int i = 0;
        for (Sort.Order order : sort) {
            Optional<Predicate> eqPredicateOptional;
            String property = order.getProperty();
            Sort.Direction orderDirection = order.getDirection();
            PropertyPath path = this.getPropertyPath(property, typeInformation);
            if (path == null) continue;
            if (cursor.size() <= i) {
                throw new IllegalStateException(String.format("'%s' does not appear to be a valid cursor", cursor));
            }
            Object value = cursor.getRawValue(i);
            Optional<Predicate> orderPredicateOptional = this.invokeBinding(path, value, direction == Direction.AFTER == orderDirection.isDescending() ? Ops.LT : Ops.GT);
            if (orderPredicateOptional.isPresent()) {
                builder.or((Predicate)new BooleanBuilder((Predicate)basePredicate).and(orderPredicateOptional.get()));
            }
            if ((eqPredicateOptional = this.invokeBinding(path, value, Ops.EQ)).isPresent()) {
                basePredicate = new BooleanBuilder((Predicate)basePredicate).and(eqPredicateOptional.get());
            }
            ++i;
        }
        return builder;
    }

    Optional<Predicate> invokeBinding(PropertyPath propertyPath, Object object, Ops ops) {
        Path<?> path = CursorPredicateFactory.reifyPath(this.resolver, propertyPath);
        if (path instanceof SimpleExpression) {
            SimpleExpression expression = (SimpleExpression)path;
            if (object == null) {
                if (Ops.EQ == ops) {
                    return Optional.of(expression.isNull());
                }
                return Optional.empty();
            }
            return Optional.of(Expressions.booleanOperation((Operator)ops, (Expression[])new Expression[]{expression, ConstantImpl.create((Object)object)}));
        }
        throw new IllegalArgumentException(String.format("Cannot create cursor predicate for path '%s' with type '%s'.", path, path.getMetadata().getPathType()));
    }

    private static Path<?> reifyPath(EntityPathResolver resolver, PropertyPath path) {
        EntityPath entityPath = resolver.createPath(path.getOwningType().getType());
        Field field = org.springframework.data.util.ReflectionUtils.findRequiredField(entityPath.getClass(), (String)path.getSegment());
        Object value = ReflectionUtils.getField((Field)field, (Object)entityPath);
        PropertyPath next = path.next();
        if (next != null) {
            return CursorPredicateFactory.reifyPath(resolver, next);
        }
        return (Path)value;
    }

    @Nullable
    PropertyPath getPropertyPath(String path, TypeInformation<?> type) {
        try {
            return PropertyPath.from((String)path, type);
        }
        catch (PropertyReferenceException e) {
            return null;
        }
    }

    private Object convertToPropertyPathSpecificType(String source, PropertyPath path) {
        Class<ObjectId> targetType = path.getLeafType();
        Field field = ReflectionUtils.findField((Class)path.getOwningType().getType(), (String)path.getSegment());
        if (field != null && AnnotatedElementUtils.hasMetaAnnotationTypes((AnnotatedElement)field, Id.class)) {
            targetType = ObjectId.class;
        }
        if (!StringUtils.hasLength((String)source)) {
            return null;
        }
        return this.conversionService.canConvert(String.class, targetType) ? this.conversionService.convert((Object)source, TypeDescriptor.forObject((Object)source), CursorPredicateFactory.getTargetTypeDescriptor(path)) : source;
    }

    private static TypeDescriptor getTargetTypeDescriptor(PropertyPath path) {
        TypeDescriptor result;
        String name;
        Class owningType = path.getLeafProperty().getOwningType().getType();
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor((Class)owningType, (String)(name = path.getLeafProperty().getSegment()));
        TypeDescriptor typeDescriptor = result = descriptor == null ? TypeDescriptor.nested((Field)org.springframework.data.util.ReflectionUtils.findRequiredField((Class)owningType, (String)name), (int)0) : TypeDescriptor.nested((Property)new Property(owningType, descriptor.getReadMethod(), descriptor.getWriteMethod(), name), (int)0);
        if (result == null) {
            throw new IllegalStateException(String.format("Could not obtain TypeDescriptor for PathInformation %s!", path));
        }
        return result;
    }

    public static enum Direction {
        AFTER,
        BEFORE;

    }
}

