/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.querydsl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.beast.data.relay.Cursor;
import org.beast.data.relay.DefaultCursor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.Property;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class CursorEncoder {
    private final ConversionService conversionService;

    public CursorEncoder(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Cursor encode(Sort sort, Object object) {
        return this.encode(sort, object, ClassUtils.getUserClass((Object)object));
    }

    public Cursor encode(Sort sort, Object object, Class<?> clazz) {
        return this.encode((TypeInformation<?>)ClassTypeInformation.from(clazz), sort, object);
    }

    public Cursor encode(TypeInformation<?> type, Sort sort, Object object) {
        ArrayList<String> values = new ArrayList<String>();
        for (Sort.Order order : sort) {
            Method readMethod;
            String property = order.getProperty();
            PropertyPath path = this.getPropertyPath(property, type);
            if (path == null) continue;
            String segment = path.getSegment();
            TypeDescriptor source = CursorEncoder.getTargetTypeDescriptor(path);
            PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor((Class)type.getType(), (String)segment);
            if (descriptor == null || (readMethod = descriptor.getReadMethod()) == null) continue;
            String value = null;
            try {
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object entryValue = readMethod.invoke(object, new Object[0]);
                value = (String)this.conversionService.convert(entryValue, source, TypeDescriptor.valueOf(String.class));
            }
            catch (Exception ex) {
                throw new FatalBeanException("Could not create Cursor from property '" + readMethod.getName() + "'", (Throwable)ex);
            }
            values.add(value);
        }
        return DefaultCursor.valueOfCursors(values);
    }

    @Nullable
    PropertyPath getPropertyPath(String path, TypeInformation<?> type) {
        try {
            return PropertyPath.from((String)path, type);
        }
        catch (PropertyReferenceException e) {
            return null;
        }
    }

    private static TypeDescriptor getTargetTypeDescriptor(PropertyPath path) {
        TypeDescriptor result;
        String name;
        Class owningType = path.getLeafProperty().getOwningType().getType();
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor((Class)owningType, (String)(name = path.getLeafProperty().getSegment()));
        TypeDescriptor typeDescriptor = result = descriptor == null ? TypeDescriptor.nested((Field)ReflectionUtils.findRequiredField((Class)owningType, (String)name), (int)0) : TypeDescriptor.nested((Property)new Property(owningType, descriptor.getReadMethod(), descriptor.getWriteMethod(), name), (int)0);
        if (result == null) {
            throw new IllegalStateException(String.format("Could not obtain TypeDesciptor for PathInformation %s!", path));
        }
        return result;
    }
}

