/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.querydsl.binding;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.Property;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.binding.CustomQuerydslDefaultBinding;
import org.springframework.data.querydsl.binding.MultiValueBinding;
import org.springframework.data.querydsl.binding.PathInformation;
import org.springframework.data.querydsl.binding.QuerydslBindings;
import org.springframework.data.querydsl.binding.QuerydslPredicateBuilder;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class CustomQuerydslPredicateBuilder
extends QuerydslPredicateBuilder {
    private final MultiValueBinding<Path<? extends Object>, Object> defaultBinding = new CustomQuerydslDefaultBinding();
    private final Map<PathInformation, Path<?>> paths = new ConcurrentHashMap();
    private final ConversionService conversionService;
    private final EntityPathResolver resolver;
    private static final Pattern PATTERN = Pattern.compile("^.*\\[.*]$");

    public CustomQuerydslPredicateBuilder(ConversionService conversionService, EntityPathResolver resolver) {
        super(conversionService, resolver);
        this.conversionService = conversionService;
        this.resolver = resolver;
    }

    @Nullable
    public Predicate getPredicate(TypeInformation<?> type, MultiValueMap<String, String> values, QuerydslBindings bindings) {
        Assert.notNull((Object)bindings, (String)"Context must not be null!");
        BooleanBuilder builder = new BooleanBuilder();
        if (values.isEmpty()) {
            return builder.getValue();
        }
        for (Map.Entry entry : values.entrySet()) {
            PathInformation propertyPath;
            String path;
            if (CustomQuerydslPredicateBuilder.isSingleElementCollectionWithoutText((List)entry.getValue())) continue;
            String property = path = (String)entry.getKey();
            String mapKey = null;
            if (path.contains("[") && PATTERN.matcher(path).matches() && path.endsWith("]")) {
                int propertySpitIndex = path.indexOf("[");
                property = property.substring(0, propertySpitIndex);
                mapKey = path.substring(propertySpitIndex + 1, path.length() - 1);
            }
            if (!bindings.isPathAvailable(property, type) || (propertyPath = bindings.getPropertyPath(property, type)) == null) continue;
            Collection<Object> value = mapKey != null ? Collections.singleton(Map.of(mapKey, (String)((List)entry.getValue()).get(0))) : this.convertToPropertyPathSpecificType((List)entry.getValue(), propertyPath);
            Optional<Predicate> predicate = this.invokeBinding(propertyPath, bindings, value);
            predicate.ifPresent(arg_0 -> ((BooleanBuilder)builder).and(arg_0));
        }
        return builder.getValue();
    }

    private static boolean isSingleElementCollectionWithoutText(List<String> source) {
        return source.size() == 1 && !StringUtils.hasLength((String)source.get(0));
    }

    private Optional<Predicate> invokeBinding(PathInformation dotPath, QuerydslBindings bindings, Collection<Object> values) {
        Path<?> path = this.getPath(dotPath, bindings);
        return bindings.getBindingForPath(dotPath).orElse(this.defaultBinding).bind(path, values);
    }

    private Path<?> getPath(PathInformation path, QuerydslBindings bindings) {
        Optional resolvedPath = bindings.getExistingPath(path);
        return resolvedPath.orElseGet(() -> this.paths.computeIfAbsent(path, it -> it.reifyPath(this.resolver)));
    }

    private Collection<Object> convertToPropertyPathSpecificType(List<String> source, PathInformation path) {
        Class targetType = path.getLeafType();
        if (source.isEmpty() || CustomQuerydslPredicateBuilder.isSingleElementCollectionWithoutText(source)) {
            return Collections.emptyList();
        }
        ArrayList<Object> target = new ArrayList<Object>(source.size());
        for (String value : source) {
            target.add(this.conversionService.canConvert(String.class, targetType) ? this.conversionService.convert((Object)value, TypeDescriptor.forObject((Object)value), CustomQuerydslPredicateBuilder.getTargetTypeDescriptor(path)) : value);
        }
        return target;
    }

    private static TypeDescriptor getTargetTypeDescriptor(PathInformation path) {
        TypeDescriptor result;
        PropertyDescriptor descriptor = path.getLeafPropertyDescriptor();
        Class owningType = path.getLeafParentType();
        String leafProperty = path.getLeafProperty();
        TypeDescriptor typeDescriptor = result = descriptor == null ? TypeDescriptor.nested((Field)ReflectionUtils.findRequiredField((Class)owningType, (String)leafProperty), (int)0) : TypeDescriptor.nested((Property)new Property(owningType, descriptor.getReadMethod(), descriptor.getWriteMethod(), leafProperty), (int)0);
        if (result == null) {
            throw new IllegalStateException(String.format("Could not obtain TypeDesciptor for PathInformation %s!", path));
        }
        return result;
    }
}

