/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.querydsl.configuration;

import java.util.Optional;
import org.beast.data.querydsl.CursorEncoder;
import org.beast.data.querydsl.CursorPredicateFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.SimpleEntityPathResolver;

@Configuration(proxyBeanMethods=false)
public class DataCursorAutoConfiguration {
    @Autowired
    ObjectProvider<EntityPathResolver> resolver;

    @Bean
    public CursorEncoder cursorEncoder(@Qualifier(value="mvcConversionService") Optional<ConversionService> conversionServiceOptional) {
        ConversionService conversionService = conversionServiceOptional.orElse(DefaultConversionService.getSharedInstance());
        return new CursorEncoder(conversionService);
    }

    @Bean
    public CursorPredicateFactory cursorPredicateFactory(@Qualifier(value="mvcConversionService") Optional<ConversionService> conversionServiceOptional, CursorEncoder encoder) {
        ConversionService conversionService = conversionServiceOptional.orElse(DefaultConversionService.getSharedInstance());
        return new CursorPredicateFactory(conversionService, (EntityPathResolver)this.resolver.getIfUnique(() -> SimpleEntityPathResolver.INSTANCE), encoder);
    }
}

