/*
 * Decompiled with CFR 0.152.
 */
package org.beast.data.querydsl;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import org.beast.data.domain.OrdersCursor;
import org.beast.data.querydsl.CursorEncoder;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.Property;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.annotation.Id;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class CursorPredicateFactory {
    private final ConversionService conversionService;
    private final EntityPathResolver resolver;

    public CursorPredicateFactory(ConversionService conversionService, EntityPathResolver resolver, CursorEncoder encoder) {
        this.conversionService = conversionService;
        this.resolver = resolver;
    }

    @Nullable
    public Predicate after(TypeInformation<?> type, @Nullable OrdersCursor cursor, Sort sort) {
        return this.predicate(type, cursor, sort, true);
    }

    @Nullable
    public Predicate before(TypeInformation<?> type, @Nullable OrdersCursor cursor, Sort sort) {
        return this.predicate(type, cursor, sort, false);
    }

    @Nullable
    private Predicate predicate(TypeInformation<?> type, @Nullable OrdersCursor cursor, Sort sort, boolean isAfter) {
        BooleanBuilder builder = new BooleanBuilder();
        if (cursor == null) {
            return builder.getValue();
        }
        List orders = cursor.getOrders();
        int i = 0;
        BooleanBuilder basePredicate = new BooleanBuilder();
        for (Sort.Order order : sort) {
            Optional<Predicate> eqPredicateOptional;
            Object value;
            String property = order.getProperty();
            Sort.Direction direction = order.getDirection();
            PropertyPath path = this.getPropertyPath(property, type);
            if (path == null) continue;
            if (orders.size() <= i) {
                throw new IllegalStateException(String.format("'%s' does not appear to be a valid cursor", cursor));
            }
            String entryValue = (String)orders.get(i);
            try {
                value = this.convertToPropertyPathSpecificType(entryValue, path);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("'%s' does conversion failed", path), e);
            }
            Optional<Predicate> orderPredicateOptional = this.invokeBinding(path, value, isAfter == direction.isDescending() ? Ops.LT : Ops.GT);
            if (orderPredicateOptional.isPresent()) {
                builder.or((Predicate)new BooleanBuilder((Predicate)basePredicate).and(orderPredicateOptional.get()));
            }
            if ((eqPredicateOptional = this.invokeBinding(path, value, Ops.EQ)).isPresent()) {
                basePredicate = new BooleanBuilder((Predicate)basePredicate).and(eqPredicateOptional.get());
            }
            ++i;
        }
        return builder.getValue();
    }

    Optional<Predicate> invokeBinding(PropertyPath propertyPath, Object object, Ops ops) {
        Path<?> path = CursorPredicateFactory.reifyPath(this.resolver, propertyPath);
        if (path instanceof SimpleExpression) {
            SimpleExpression expression = (SimpleExpression)path;
            return Optional.of(object == null ? expression.isNull() : Expressions.booleanOperation((Operator)ops, (Expression[])new Expression[]{expression, ConstantImpl.create((Object)object)}));
        }
        throw new IllegalArgumentException(String.format("Cannot create cursor predicate for path '%s' with type '%s'.", path, path.getMetadata().getPathType()));
    }

    private static Path<?> reifyPath(EntityPathResolver resolver, PropertyPath path) {
        EntityPath entityPath = resolver.createPath(path.getOwningType().getType());
        Field field = org.springframework.data.util.ReflectionUtils.findRequiredField(entityPath.getClass(), (String)path.getSegment());
        Object value = ReflectionUtils.getField((Field)field, (Object)entityPath);
        PropertyPath next = path.next();
        if (next != null) {
            return CursorPredicateFactory.reifyPath(resolver, next);
        }
        return (Path)value;
    }

    @Nullable
    PropertyPath getPropertyPath(String path, TypeInformation<?> type) {
        try {
            return PropertyPath.from((String)path, type);
        }
        catch (PropertyReferenceException e) {
            return null;
        }
    }

    private Object convertToPropertyPathSpecificType(String source, PropertyPath path) {
        Class<ObjectId> targetType = path.getLeafType();
        Field field = ReflectionUtils.findField((Class)path.getOwningType().getType(), (String)path.getSegment());
        if (field != null && AnnotatedElementUtils.hasMetaAnnotationTypes((AnnotatedElement)field, Id.class)) {
            targetType = ObjectId.class;
        }
        if (!StringUtils.hasLength((String)source)) {
            return null;
        }
        return this.conversionService.canConvert(String.class, targetType) ? this.conversionService.convert((Object)source, TypeDescriptor.forObject((Object)source), CursorPredicateFactory.getTargetTypeDescriptor(path)) : source;
    }

    private static TypeDescriptor getTargetTypeDescriptor(PropertyPath path) {
        TypeDescriptor result;
        String name;
        Class owningType = path.getLeafProperty().getOwningType().getType();
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor((Class)owningType, (String)(name = path.getLeafProperty().getSegment()));
        TypeDescriptor typeDescriptor = result = descriptor == null ? TypeDescriptor.nested((Field)org.springframework.data.util.ReflectionUtils.findRequiredField((Class)owningType, (String)name), (int)0) : TypeDescriptor.nested((Property)new Property(owningType, descriptor.getReadMethod(), descriptor.getWriteMethod(), name), (int)0);
        if (result == null) {
            throw new IllegalStateException(String.format("Could not obtain TypeDescriptor for PathInformation %s!", path));
        }
        return result;
    }
}

