package org.springframework.data.querydsl.binding;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.MapPath;
import org.springframework.data.querydsl.binding.QuerydslDefaultBinding;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class CustomQuerydslDefaultBinding extends QuerydslDefaultBinding {


    @Override
    public Optional<Predicate> bind(Path<?> path, Collection<?> value) {
        if (value.isEmpty()) {
            return Optional.empty();
        }

        if (path instanceof MapPath) {

            BooleanBuilder builder = new BooleanBuilder();


            for (Object element : value) {
                Map<String, Object> map = (Map<String, Object>) element;
                map.forEach((key, keyValue) -> {
                    builder.and(((MapPath)path).contains(key, keyValue));
                });
            }
            return Optional.of(builder);
        }

        return super.bind(path, value);
    }
}
