package org.beast.data.mongo;

import com.querydsl.core.types.*;
import com.querydsl.core.types.dsl.BooleanOperation;

public class Expressions {

    public static <T> BooleanOperation lt(Path<?> parent, Class<T> propertyClass, String property, T value) {
        PathMetadata metadata = PathMetadataFactory.forProperty(parent, property);
        Path<T> path = ExpressionUtils.path(propertyClass, metadata);
        Constant<T> constant = ConstantImpl.create(value);;
        return com.querydsl.core.types.dsl.Expressions.booleanOperation(
                Ops.LT, new Expression[]{path, constant
        });
    }


}
