package org.beast.data.jackson.relay;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.beast.data.relay.*;

public class RelayJacksonModule extends Module {
    @Override
    public String getModuleName() {
        return "RelayJacksonModule";
    }

    @Override
    public Version version() {
        return new Version(0, 1, 0, "", null, null);
    }

    @Override
    public void setupModule(SetupContext context) {
        context.setMixInAnnotations(Cursor.class, CursorMixIn.class);
        context.setMixInAnnotations(Edge.class, EdgeMixIn.class);
        context.setMixInAnnotations(PageInfo.class, PageInfoMixIn.class);
        context.setMixInAnnotations(Connection.class, ConnectionMinIn.class);
//        context.addDeserializers(EdgeDeserializer.class);
    }

    @JsonDeserialize(as = SimpleCursor.class)
    @JsonIgnoreProperties(ignoreUnknown = true)
    private interface CursorMixIn {

    }

    @JsonDeserialize(as = SimpleConnection.class)
    @JsonIgnoreProperties(ignoreUnknown = true)
    private interface ConnectionMinIn {

    }
//    @JsonDeserialize(as = SimpleEdge.class)
    @JsonDeserialize(using = EdgeDeserializer.class)
    @JsonIgnoreProperties(ignoreUnknown = true)
    private interface EdgeMixIn {

    }

    @JsonDeserialize(as = SimplePageInfo.class)
    @JsonIgnoreProperties(ignoreUnknown = true)
    private interface PageInfoMixIn {

    }


}
