package org.beast.data.jackson.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import org.beast.data.domain.PageResult;
import org.springframework.data.domain.Page;

import java.io.IOException;

public class PageSerializer extends StdScalarSerializer<Page> {

    public PageSerializer() {
        super(Page.class);
    }

    @Override
    public void serialize(Page page, JsonGenerator gen, SerializerProvider provider) throws IOException {
        PageResult<?> result = new PageResult<>(page.getContent(), page.getTotalElements());
        gen.writeObject(result);
    }
}
