package org.beast.data.jackson.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import org.beast.data.message.ErrorInfo;
import org.beast.data.message.ErrorMessageSource;
import org.beast.data.message.MessageError;

import java.io.IOException;

public class MessageErrorSerializer extends StdScalarSerializer<MessageError> {

    private ErrorMessageSource errorMessageSource;


    public MessageErrorSerializer(ErrorMessageSource errorMessageSource) {
        super(MessageError.class);
        this.errorMessageSource = errorMessageSource;
    }

    @Override
    public void serialize(MessageError value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        String errorCode = value.getCode();
        String message = errorMessageSource.getMessage(value);;
        gen.writeObject(new ErrorInfo(errorCode, message));
    }
}
