package org.beast.data.jackson.relay;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import org.beast.data.relay.SimpleCursor;
import org.beast.data.relay.SimpleEdge;
import org.beast.data.relay.Edge;

import java.io.IOException;
import java.util.Objects;

public class EdgeDeserializer extends StdScalarDeserializer<Edge<?>> implements ContextualDeserializer {

    private JavaType nodeType;

    public EdgeDeserializer() {
        this(null);
    }

    public EdgeDeserializer(JavaType nodeType) {
        super(Edge.class);
        this.nodeType = nodeType;
    }


    @Override
    public Edge<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {

//        DefaultEdge<?> wrapper = new DefaultEdge<>();
//        wrapper.setNode(ctxt.readValue(p, type));


//        var type = ctxt.getTypeFactory().constructParametricType(Edge.class, type);

        JsonNode jsonNode = p.readValueAsTree();
        var cursor = ctxt.readTreeAsValue(jsonNode.get("cursor"), SimpleCursor.class);
        Object node = null;
        if (Objects.nonNull(nodeType)) {
            node = ctxt.readTreeAsValue(jsonNode.get("node"), nodeType);
        }

        return new SimpleEdge<>(node, cursor);

//        return p.readValueAs(DefaultEdge.class);
    }


    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        var type = ctxt.getContextualType();
        if (Objects.isNull(type)) {
            type = property.getType().containedType(0);
        }
        var nodeType = type.getBindings().getBoundType(0);
        return new EdgeDeserializer(nodeType);
    }
}
