package org.beast.data.jackson.ser;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import org.beast.data.relay.DefaultPageInfo;
import org.beast.data.relay.PageInfo;

import java.io.IOException;

public class PageInfoDeserializer extends StdScalarDeserializer<PageInfo> {
    public PageInfoDeserializer() {
        super(PageInfo.class);
    }

    @Override
    public PageInfo deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        return p.readValueAs(DefaultPageInfo.class);
    }
}
