package org.beast.data.jackson.ser;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import org.beast.data.relay.Cursor;
import org.beast.data.relay.DefaultCursor;

import java.io.IOException;

public class CursorDeserializer extends FromStringDeserializer<Cursor> {
    public CursorDeserializer() {
        super(Cursor.class);
    }

    @Override
    protected Cursor _deserialize(String value, DeserializationContext ctxt) throws IOException {
        return DefaultCursor.ofNullable(value);
    }
}
