package org.beast.data.jackson.ser;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import org.beast.data.relay.Connection;
import org.beast.data.relay.DefaultConnection;

import java.io.IOException;

public class ConnectionDeserializer extends StdScalarDeserializer<Connection<?>> {
    public ConnectionDeserializer() {
        super(Connection.class);
    }

    @Override
    public Connection<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
//        return p.readValueAs(DefaultConnection.class);
        return ctxt.readValue(p, DefaultConnection.class);
    }
}
