package org.beast.data.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.beast.data.jackson.deser.SimpleMoneyDeserializer;
import org.beast.data.jackson.ser.SimpleMoneySerializer;
import org.beast.data.domain.SimpleMoney;


public class MoneyModule extends SimpleModule {

    public MoneyModule() {
        super("Money");
        this.addDeserializer(SimpleMoney.class, new SimpleMoneyDeserializer());
        this.addSerializer(SimpleMoney.class, new SimpleMoneySerializer());
    }
}
